<?php

namespace App\Http\Controllers\Apps;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;

class DeveloperFeatureController extends Controller
{
    public function render_logo_update()
    {
        return view('pages.apps.dev.logo-update.index');
    }

    public function update_logo(Request $request)
    {
        $validatedRequest = $request->validate([
            'logo_lg' => [
                Rule::excludeIf($request->file('logo_lg') === null),
                'mimes:svg'
            ],
            'logo_sm' => [
                Rule::excludeIf($request->file('logo_sm') === null),
                'mimes:svg'
            ],
            'favicon' => [
                Rule::excludeIf($request->file('favicon') === null),
                'mimes:ico'
            ],
        ]);

        if (isset($validatedRequest['logo_lg'])) {
            $validatedRequest['logo_lg']->move(public_path('assets/media/logos'), 'default-dark.svg');
        }

        if (isset($validatedRequest['logo_sm'])) {
            $validatedRequest['logo_sm']->move(public_path('assets/media/logos'), 'default-small.svg');
        }

        if (isset($validatedRequest['favicon'])) {
            $validatedRequest['favicon']->move(public_path('assets/media/logos'), 'favicon.ico');
        }

        return back()
            ->with('success', 'Berhasil update gambar.');
    }
}
