<?php

namespace App\Http\Controllers;

use App\DataTables\CouponsDataTable;
use App\DataTables\PrizesDataTable;
use App\DataTables\SpinLogDataTable;

class ViewController extends Controller
{
    public function render_web_setting()
    {
        return view('pages.apps.settings.config.index');
    }

    public function render_wheel_setting()
    {
        return view('pages.apps.settings.wheel.index');
    }

    public function render_claim_setting()
    {
        return view('pages.apps.settings.claim.index');
    }

    public function render_dummy()
    {
        return view('pages.apps.wheel.dummy.index');
    }

    public function render_prize(PrizesDataTable $dataTable)
    {
        return $dataTable->render('pages.apps.wheel.prizes.list');
    }

    public function render_coupon(CouponsDataTable $dataTable)
    {
        return $dataTable->render('pages.apps.wheel.coupons.list');
    }

    public function render_history(SpinLogDataTable $dataTable)
    {
        return $dataTable->render('pages.apps.logs.list');
    }
}
