<?php

namespace App\Livewire;

use App\Livewire\Traits\ExceptionHandler;
use App\Models\Wheel;
use Livewire\Attributes\Validate;
use Livewire\Component;

class ClaimForm extends Component
{
    use ExceptionHandler;
    /**
     * Give context to custom exception handler
     *
     * @var array $context
     */
    protected $context = 'klaim';

    #[Validate('required|string', as: 'Teks klaim', translate: false)]
    public $text;

    #[Validate('required|string', as: 'Nomor telfon', translate: false)]
    public $number;

    public function messages()
    {
        return [
            'required' => ':attribute tidak boleh kosong',
            'string' => ':attribute tidak boleh memiliki karakter lain selain huruf',
        ];
    }

    public function mount()
    {
        tap(Wheel::first(), function ($wheel) {
            $this->number = $wheel->claim_number;
            $this->text = $wheel->claim_text;
        });
    }

    public function update()
    {
        $request = $this->validate();

        try {
            $claim = Wheel::first();

            $claim->claim_number = $request['number'];
            $claim->claim_text = $request['text'];
            $claim->save();
        } catch (\PDOException $e) {
            return $this->handleDatabaseException($e);
        } catch (\Exception $e) {
            return $this->handleDefaultException($e);
        }

        $this->dispatch('success', 'Data klaim berhasil di update');
    }

    public function hydrate()
    {
        $this->resetErrorBag();
        $this->resetValidation();
    }
}
