<?php

namespace App\Livewire;

use App\Livewire\Traits\ExceptionHandler;
use App\Models\Prizes;
use Intervention\Image\Drivers\Imagick\Driver;
use Intervention\Image\ImageManager;
use Livewire\Attributes\On;
use Livewire\Attributes\Validate;
use Livewire\Component;
use Livewire\WithFileUploads;

class PrizeModal extends Component
{
    use ExceptionHandler, WithFileUploads;

    /**
     * Give context to custom exception handler
     *
     * @var array $context
     */
    protected $context = 'web setting';

    public Prizes $prize;

    #[Validate('required|string', as: 'Hadiah', onUpdate: false, translate: false)]
    public $text;

    #[Validate('nullable|mimes:png,jpg,webp', as: 'Gambar hadiah', onUpdate: false, translate: false)]
    public $image;

    public function messages()
    {
        return [
            'required' => ':attribute tidak boleh kosong',
            'string' => ':attribute tidak boleh memiliki karakter lain selain huruf',
            'mimes' => ':attribute hanya menerima ekstensi .png, .jpg, .webp'
        ];
    }

    #[On('show')]
    public function show(Prizes $prize)
    {
        $this->prize = $prize;
        $this->text = $prize->text;
    }

    public function update()
    {
        $request = $this->validate();

        try {
            $prize = $this->prize;
            $prize->text = $request['text'];

            if (isset($request['image'])) {
                $formater = new ImageManager(new Driver());
                $image = $formater->read($request['image']);
                $image->resize(172, 225);

                $webp = $image->toWebp();
                $webp->save(public_path('assets/img/prizes/' . $prize->image));
            }

            $prize->save();
        } catch (\PDOException $e) {
            return $this->handleDatabaseException($e);
        } catch (\Exception $e) {
            return $this->handleDefaultException($e);
        }

        $this->dispatch('success', 'Hadiah berhasil di update');
        $this->reset();
    }

    public function hydrate()
    {
        $this->resetErrorBag();
        $this->resetValidation();
    }
}
