<?php

namespace App\Livewire;

use App\Livewire\Traits\ExceptionHandler;
use App\Models\WebConfig;
use Livewire\Attributes\Validate;
use Livewire\Component;

class WebOptional extends Component
{
    use ExceptionHandler;
    /**
     * Give context to custom exception handler
     *
     * @var array $context
     */
    protected $context = 'web setting';

    #[Validate('nullable|string', as: 'Site name', translate: false)]
    public $og_site_name;

    #[Validate('nullable|string', as: 'Title', translate: false)]
    public $og_title;

    #[Validate('nullable|string', as: 'Type', translate: false)]
    public $og_type;

    #[Validate('nullable|string', as: 'Locale', translate: false)]
    public $og_locale;

    #[Validate('nullable|string', as: 'Url', translate: false)]
    public $og_url;

    #[Validate('nullable|string', as: 'Deskripsi', translate: false)]
    public $og_description;

    #[Validate('nullable|string', as: 'Twitter card', translate: false)]
    public $twt_card;

    #[Validate('nullable|string', as: 'Title', translate: false)]
    public $twt_title;

    #[Validate('nullable|string', as: 'Site', translate: false)]
    public $twt_site;

    #[Validate('nullable|string', as: 'Creator', translate: false)]
    public $twt_creator;

    #[Validate('nullable|string', as: 'Url', translate: false)]
    public $twt_url;

    #[Validate('nullable|string', as: 'Deskripsi', translate: false)]
    public $twt_description;


    public function messages()
    {
        return [
            'required' => ':attribute tidak boleh kosong',
            'string' => ':attribute tidak boleh memiliki karakter lain selain huruf',
        ];
    }

    public function mount()
    {
        tap(WebConfig::first(), function ($config) {
            $this->og_site_name = $config->open_graph['og_site_name'] ?? '';
            $this->og_title = $config->open_graph['og_title'] ?? '';
            $this->og_type = $config->open_graph['og_type'] ?? '';
            $this->og_locale = $config->open_graph['og_locale'] ?? '';
            $this->og_url = $config->open_graph['og_url'] ?? '';
            $this->og_description = $config->open_graph['og_description'] ?? '';

            $this->twt_card = $config->twitter['twt_card'] ?? '';
            $this->twt_title = $config->twitter['twt_title'] ?? '';
            $this->twt_site = $config->twitter['twt_site'] ?? '';
            $this->twt_creator = $config->twitter['twt_creator'] ?? '';
            $this->twt_url = $config->twitter['twt_url'] ?? '';
            $this->twt_description = $config->twitter['twt_description'] ?? '';
        });
    }

    public function update()
    {
        $request = $this->validate();

        try {
            $config = WebConfig::first();

            $config->open_graph = [
                'og_site_name' => $request['og_site_name'],
                'og_title' => $request['og_title'],
                'og_type' => $request['og_type'],
                'og_locale' => $request['og_locale'],
                'og_url' => $request['og_url'],
                'og_description' => $request['og_description'],
            ];
            $config->twitter = [
                'twt_card' => $request['twt_card'],
                'twt_title' => $request['twt_title'],
                'twt_site' => $request['twt_site'],
                'twt_creator' => $request['twt_creator'],
                'twt_url' => $request['twt_url'],
                'twt_description' => $request['twt_description'],
            ];
            $config->save();
        } catch (\PDOException $e) {
            return $this->handleDatabaseException($e);
        } catch (\Exception $e) {
            return $this->handleDefaultException($e);
        }

        $this->dispatch('success', 'Data website berhasil di update');
    }

    public function hydrate()
    {
        $this->resetErrorBag();
        $this->resetValidation();
    }
}
