<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class WebConfig extends Model
{
    use HasFactory;

    protected $table = 'config';

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'title',
        'canonical',
        'keyword',
        'description',
        'open_graph',
        'twitter',
        'icon',
        'gtag',
        'customCss',
        'customJs',
        'maintenance',
        'created_at',
        'updated_at'
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array
     */
    protected $casts = [
        'open_graph' => 'array',
        'twitter' => 'array',
    ];
}
