<?php

namespace Database\Factories;

use App\Models\Agent;
use App\Models\AgentFund;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Agent>
 */
class AgentFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'code' => strtoupper(Str::random(3)),
        ];
    }

    /**
     * Configure the model factory.
     */
    public function configure(): static
    {
        return $this->afterCreating(function (Agent $agent) {
            if ($agent->code == 'SBO1' || $agent->code == 'SBO2' || $agent->code == 'SBO3' || $agent->code == 'SBO5' || $agent->code == 'IBC') {
                AgentFund::factory()->createMany([
                    ['agent_id' => $agent->id, 'type' => 'CREDIT BALANCE', 'end_fund' => 40000, 'total_fund' => 40000],
                    ['agent_id' => $agent->id, 'type' => 'MEMBER BALANCE', 'end_fund' => 40000, 'total_fund' => 40000]
                ]);
            } else {
                AgentFund::factory()->create(['agent_id' => $agent->id, 'type' => $agent->code, 'end_fund' => 40000, 'total_fund' => 40000]);
            }
        });
    }
}
