<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('wheel_config', function (Blueprint $table) {
            $table->integerIncrements('id');
            $table->string('claim_number');
            $table->text('claim_text');
            $table->string('body_background');
            $table->string('popup_background');
            $table->string('wheel_background');
            $table->string('win_sound');
            $table->string('opening_sound');
            $table->string('animation_type')->default('spinToStop');
            $table->integer('animation_duration');
            $table->integer('total_spin');
            $table->text('segment');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('wheel_config');
    }
};
