<div class="card mb-6" x-data="global">
    <div class="card-header card-header-stretch pb-0">
        <div class="card-title">
            <div class="d-flex justify-content-end" data-kt-coupon-table-toolbar="base">
                <button type="button" class="btn btn-primary" @click="addItem()">
                    {!! getIcon('plus', 'fs-2', '', 'i') !!}
                    Tambah Form
                </button>
            </div>
        </div>
        <div class="card-toolbar"></div>
    </div>
    <div class="card-body">
        <form id="kt_coupon_form" class="form" action="#" enctype="multipart/form-data" wire:submit="store">
            <template x-for="(item, index) in coupons" :key='index'>
                <div>
                    <div class="d-flex justify-content-between gap-10">
                        <div class="d-flex flex-column w-100">
                            <div class="row g-5 mb-7">
                                <div class="col fv-row">
                                    <label class="required fw-semibold fs-6 mb-2">Username</label>
                                    <input type="text"class="form-control form-control-solid mb-3 mb-lg-0"
                                        x-model="item.username" placeholder="Username" />
                                    <template x-if="checkError(index, 'username')">
                                        <span class="text-danger" x-text="getError(index, 'username')"></span>
                                    </template>
                                </div>
                                <div class="col fv-row">
                                    <label class="required fs-6 fw-semibold mb-2">Hadiah</label>
                                    <div wire:ignore>
                                        <select class="form-select form-select-solid" x-model="item.prize"
                                            data-control="select2" data-dropdown-parent="#kt_coupon_form"
                                            data-dropdown-parent="body">
                                            <option value="">Pilih Hadiah</option>
                                            @foreach ($this->prizes as $prize)
                                                <option value="{{ $prize->id }}">{{ ucwords($prize->text) }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <template x-if="checkError(index, 'prize')">
                                        <span class="text-danger" x-text="getError(index, 'prize')"></span>
                                    </template>
                                </div>
                                <div class="col fv-row">
                                    <label class="required fw-semibold fs-6 mb-2">Tanggal Kadaluarsa</label>
                                    <input type="date" x-model="item.expired"
                                        class="form-control form-control-solid mb-3 mb-lg-0"
                                        min="{{ \Carbon\Carbon::now()->format('Y-m-d') }}" />
                                    <template x-if="checkError(index, 'expired')">
                                        <span class="text-danger" x-text="getError(index, 'expired')"></span>
                                    </template>
                                </div>
                            </div>
                        </div>
                        <template x-if="coupons.length > 1">
                            <button type="button" @click="removeItem(index)"
                                class="align-self-center btn btn-icon btn-danger">
                                {!! getIcon('trash', 'fs-2', '', 'i') !!}
                            </button>
                        </template>
                    </div>
                    <div class="separator border-2 border-gray mt-3 mb-6"></div>
                </div>
            </template>
            <div class="text-start pt-5">
                <button type="submit" class="btn btn-primary" data-kt-users-modal-action="submit"
                    wire:loading.attr="disabled">
                    <span class="indicator-label" wire:loading.remove>Submit</span>
                    <span wire:loading>
                        Please wait...
                        <span class="spinner-border spinner-border-sm align-middle ms-2"></span>
                    </span>
                </button>
            </div>
        </form>
    </div>
</div>

@script
    <script>
        Alpine.data('global', () => ({
            coupons: $wire.entangle('coupons'),
            addItem() {
                this.coupons.push(Object.assign({}, $wire.emptyCoupon));
            },
            removeItem(index) {
                this.coupons.splice(index, 1)
            },
            checkError(index, property) {
                return $wire.__instance.snapshot.memo.errors && $wire.__instance.snapshot.memo.errors[
                    `coupons.${index}.${property}`];
            },
            getError(index, property) {
                return $wire.__instance.snapshot.memo.errors[`coupons.${index}.${property}`];
            }
        }));
    </script>
@endscript
