<form class="form" wire:submit="update" enctype="multipart/form-data">
    <div class="row mb-7">
        <div class="col-12 col-lg-6">
            <div class="fv-row">
                <label for="title" class="required fw-bold fs-6 mb-2">Title</label>
                <input id="title" type="text" wire:model="title"
                    class="form-control form-control-solid mb-3 mb-lg-0" maxlength="52" placeholder="Website title">
                @error('title')
                    <span class="text-danger">{{ $message }}</span>
                @enderror
            </div>
        </div>
        <div class="col-12 col-lg-6">
            <div class="fv-row">
                <label for="canonical" class="required fw-bold fs-6 mb-2">Canonical</label>
                <input id="canonical" type="text" wire:model="canonical"
                    class="form-control form-control-solid mb-3 mb-lg-0" placeholder="https://website.com">
                @error('canonical')
                    <span class="text-danger">{{ $message }}</span>
                @enderror
            </div>
        </div>
    </div>
    <div class="row mb-7">
        <div class="col-12 col-lg-6">
            <div class="fv-row">
                <label for="keyword" class="required form-label fw-bold fs-6 mb-2">Keyword</label>
                <input class="form-control form-control-solid mb-3 mb-lg-0" wire:model="keyword" id="keyword"
                    placeholder="keyword1, keyword2, keyword3" maxlength="160"></input>
                @error('keyword')
                    <span class="text-danger">{{ $message }}</span>
                @enderror
            </div>
        </div>
        <div class="col-12 col-lg-6">
            <div class="fv-row">
                <label for="gtag" class="form-label fw-bold fs-6 mb-2">Gtag Id</label>
                <input class="form-control form-control-solid mb-3 mb-lg-0" wire:model="gtag" id="gtag"
                    placeholder="G-X8RN15XXXX" maxlength="160"></input>
                @error('gtag')
                    <span class="text-danger">{{ $message }}</span>
                @enderror
            </div>
        </div>
    </div>
    <div class="fv-row mb-7">
        <label for="description" class="required form-label fw-bold fs-6 mb-2">Description</label>
        <textarea class="form-control form-control-solid mb-3 mb-lg-0" wire:model="description" id="description"
            maxlength="160"></textarea>
        @error('description')
            <span class="text-danger">{{ $message }}</span>
        @enderror
    </div>
    <div class="fv-row mb-7">
        <label for="css" class="form-label fw-bold fs-6 mb-2">Custom Css</label>
        <textarea class="form-control form-control-solid mb-3 mb-lg-0" wire:model="customCss" id="css"
            placeholder="body { display: flex; }"></textarea>
        @error('customCss')
            <span class="text-danger">{{ $message }}</span>
        @enderror
    </div>
    <div class="fv-row mb-7">
        <label for="js" class="form-label fw-bold fs-6 mb-2">Custom Js</label>
        <textarea class="form-control form-control-solid mb-3 mb-lg-0" wire:model="customJs" id="js"></textarea>
        @error('customJs')
            <span class="text-danger">{{ $message }}</span>
        @enderror
    </div>
    <div class="text-end pt-7">
        <button type="submit" class="btn btn-primary">
            <span class="indicator-label" wire:loading.remove>Submit</span>
            <span class="indicator-progress" wire:loading>
                Please wait...
                <span class="spinner-border spinner-border-sm align-middle ms-2"></span>
            </span>
        </button>
    </div>
</form>
