<form id="kt_wheel_form" class="form" wire:submit="update" enctype="multipart/form-data">
    <div class="row mb-7">
        <div class="col-12 col-lg-3">
            <div class="fv-row">
                <label for="animation-duration" class="required fw-bold fs-6 mb-2">Durasi putaran (Dalam
                    detik)</label>
                <input class="form-control form-control-solid mb-3 mb-lg-0" type="number"
                    wire:model="animation_duration" id="animation-duration" min="5">
                @error('animation_duration')
                    <span class="text-danger">{{ $message }}</span>
                @enderror
            </div>
        </div>
        <div class="col-12 col-lg-3">
            <div class="fv-row">
                <label for="total-spin" class="required fw-bold fs-6 mb-2">Kecepatan putaran</label>
                <input class="form-control form-control-solid mb-3 mb-lg-0" type="number" wire:model="total_spin"
                    id="total-spin" min="2">
                @error('total_spin')
                    <span class="text-danger">{{ $message }}</span>
                @enderror
            </div>
        </div>
        <div class="col-12 col-lg-6">
            <div class="fv-row">
                <label for="wheel-bg" class="fw-bold fs-6 mb-2">Gambar Roda Putar</label>
                <input class="form-control form-control-solid mb-3 mb-lg-0" type="file" wire:model="wheel_background"
                    id="wheel-bg">
                @error('wheel_background')
                    <span class="text-danger">{{ $message }}</span>
                @enderror
            </div>
        </div>
    </div>
    <div class="row mb-7">
        <div class="col-12 col-lg-6">
            <div class="fv-row">
                <label for="body_background" class="form-label fw-bold fs-6 mb-2">Background</label>
                <input type="file" class="form-control form-control-solid mb-3 mb-lg-0" wire:model="body_background"
                    id="body_background">
                @error('body_background')
                    <span class="text-danger">{{ $message }}</span>
                @enderror
            </div>
        </div>
        <div class="col-12 col-lg-6">
            <div class="fv-row">
                <label for="popup_background" class="fw-bold fs-6 mb-2">Popup Logo</label>
                <input class="form-control form-control-solid mb-3 mb-lg-0" type="file" wire:model="popup_background"
                    id="popup_background">
                @error('popup_background')
                    <span class="text-danger">{{ $message }}</span>
                @enderror
            </div>
        </div>
    </div>
    <div class="row mb-7">
        <div class="col-12 col-lg-6">
            <div class="fv-row">
                <label for="opening-sound" class="fw-bold fs-6 mb-2">Opening Sound</label>
                <input class="form-control form-control-solid mb-3 mb-lg-0" type="file" wire:model="opening_sound"
                    id="opening-sound">
                @error('opening_sound')
                    <span class="text-danger">{{ $message }}</span>
                @enderror
            </div>
        </div>
        <div class="col-12 col-lg-6">
            <div class="fv-row">
                <label for="win-sound" class="fw-bold fs-6 mb-2">Win Sound</label>
                <input class="form-control form-control-solid mb-3 mb-lg-0" type="file" wire:model="win_sound"
                    id="win-sound">
                @error('win_sound')
                    <span class="text-danger">{{ $message }}</span>
                @enderror
            </div>
        </div>
    </div>
    <div class="fv-row mb-7">
        <label for="segment" class="fw-bold fs-6 mb-2">Urutan Hadiah</label>
        <div wire:ignore>
            <input class="form-control form-control-solid mb-3 mb-lg-0" id="segment" x-data="tagify($el)" </div>
        </div>
        @error('segment')
            <span class="text-danger">{{ $message }}</span>
        @enderror
        <div class="text-end pt-7">
            <button type="submit" class="btn btn-primary" data-kt-users-modal-action="submit"
                wire:loading.attr="disabled"
                wire:target="update,store,wheel_background,body_background,popup_background,opening_sound,win_sound">
                <span class="indicator-label" wire:loading.remove
                    wire:target="update,store,wheel_background,body_background,popup_background,opening_sound,win_sound">Submit</span>
                <span wire:loading
                    wire:target="update,store,wheel_background,body_background,popup_background,opening_sound,win_sound">
                    Please wait...
                    <span class="spinner-border spinner-border-sm align-middle ms-2"></span>
                </span>
            </button>
        </div>
</form>

@script
    <script>
        Alpine.data('tagify', (element) => {
            return {
                prizes: $wire.entangle('prizes'),
                prefill: $wire.entangle('prefill'),

                init() {
                    let tagify = new Tagify(element, {
                        whitelist: this.prizes,
                        maxTags: 8,
                        dropdown: {
                            maxItems: this.prizes.length,
                            classname: "",
                            enabled: 0,
                            closeOnSelect: false
                        },
                        callbacks: {
                            'change': function(e) {
                                $wire.segment = JSON.parse(e.detail.value);
                            }
                        }
                    });

                    tagify.addTags(this.prefill);
                }
            }
        })
    </script>
@endscript
