// Initialize KTMenu
KTMenu.init();

let addButton = document.querySelector('[data-kt-action="add_user"]');
let updateButton = document.querySelectorAll('[data-kt-action="update_user"]');
let deleteButton = document.querySelectorAll('[data-kt-action="delete_user"]');

if (addButton) {
    addButton.addEventListener('click', function () {
        Livewire.dispatch('create');
    });
}

// Add click event listener to update buttons
if (updateButton) {
    updateButton.forEach(function (element) {
        element.addEventListener('click', function () {
            Livewire.dispatch('show', [this.getAttribute('data-kt-user-id')]);
        });
    });
}

// Add click event listener to delete buttons
if (deleteButton) {
    deleteButton.forEach(function (element) {
        element.addEventListener('click', function () {
            Swal.fire({
                text: 'Anda yakin ingin menghapus data?',
                icon: 'warning',
                buttonsStyling: false,
                showCancelButton: true,
                confirmButtonText: 'Iya',
                cancelButtonText: 'Batal',
                customClass: {
                    confirmButton: 'btn btn-danger',
                    cancelButton: 'btn btn-secondary',
                }
            }).then((result) => {
                if (result.isConfirmed) {
                    Livewire.dispatch('delete', [this.getAttribute('data-kt-user-id')]);
                }
            });
        });
    });
}

Livewire.on('success', (message) => {
    $('#kt_modal_add_user').modal('hide');
    LaravelDataTables['users-table'].ajax.reload();
});
