<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use Maatwebsite\Excel\Concerns\WithDefaultStyles;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithStrictNullComparison;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Style;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
use Yajra\DataTables\Exports\DataTablesCollectionExport;

class TransactionReportsExport extends DataTablesCollectionExport implements WithColumnFormatting, WithDefaultStyles, WithStyles, WithStrictNullComparison, WithHeadings, WithMapping
{
    public function columnFormats(): array
    {
        return [
            'B' => '#,##0',
            'C' => '#,##0',
            'D' => '#,##0',
            'E' => '#,##0',
            'F' => '#,##0',
            'G' => '#,##0',
            'H' => '#,##0',
            'I' => '#,##0',
        ];
    }

    public function defaultStyles(Style $defaultStyle)
    {
        return [
            'font' => [
                'name' => 'Calibri',
                'size' => 11,
                'bold' => true,
            ],
            'borders' => [
                'allBorders' => [
                    'borderStyle' => Border::BORDER_THIN,
                    'color' => ['rgb' => '000000']
                ],
            ],
            'alignment' => [
                'horizontal' => Alignment::HORIZONTAL_CENTER,
            ]
        ];
    }

    public function styles(Worksheet $sheet)
    {
        $columnWidth = [
            'A' => 125,
            'B' => 112,
            'C' => 112,
            'D' => 112,
            'E' => 112,
            'F' => 112,
            'G' => 112,
            'H' => 112,
            'I' => 112,
        ];

        foreach ($columnWidth as $column => $width) {
            $sheet->getColumnDimension($column)->setAutoSize(false)->setWidth($width, 'px');
        }

        return [
            'C' => [
                'font' => [
                    'color' => ['rgb' => 'ff0000']
                ]
            ],
            'I' => [
                'font' => [
                    'color' => ['rgb' => 'ff0000']
                ]
            ],

            1 => [
                'fill' => [
                    'fillType'   => Fill::FILL_SOLID,
                    'startColor' => ['rgb' => 'ff9900'],
                ],
                'font' => [
                    'color' => ['rgb' => '000000']
                ]
            ],
        ];
    }

    public function headings(): array
    {
        return [
            'DATE',
            'TOTAL DP',
            'TOTAL WD',
            'MEMBER AKTIF',
            'TOTAL TRX',
            'DEPO TRX',
            'WD TRX',
            'TOTAL BONUS',
            'PROFIT',
        ];
    }

    public function map($transaction): array
    {
        return [
            $transaction['group_date'],
            $transaction['sum_deposit'],
            $transaction['sum_withdraw'],
            $transaction['total_player'],
            $transaction['total_transaksi'],
            $transaction['total_deposit'],
            $transaction['total_withdraw'],
            $transaction['sum_bonus'],
            $transaction['profit'],
        ];
    }
}
