<?php

namespace App\Livewire;

use App\Livewire\Traits\ExceptionHandler;
use App\Models\Prizes;
use App\Models\SpinLog;
use Illuminate\Support\Str;
use Livewire\Attributes\Validate;
use Livewire\Component;

class DummyForm extends Component
{
    use ExceptionHandler;
    /**
     * Give context to custom exception handler
     *
     * @var array $context
     */
    protected $context = 'spin log';

    #[Validate('required|string', as: 'Username', onUpdate: false, translate: false)]
    public $text;

    public function messages()
    {
        return [
            'required' => ':attribute tidak boleh kosong',
            'string' => ':attribute tidak boleh memiliki karakter lain selain huruf',
        ];
    }

    public function store()
    {
        $request = $this->validate();
        $request['text'] =  preg_replace('/\s+/', '', $request['text']);
        $usernames = explode(',', $request['text']);

        try {
            $prizes = Prizes::all(['text']);
            foreach ($usernames as $value) {
                SpinLog::create([
                    'coupon_id' => strtoupper(Str::random(16, 'ABCDEFGHIJKLMNOPQRSTUVWXY1234567890')),
                    'prize' => $prizes->random(1),
                    'username' => $value,
                    'created_at' => time(),
                    'ip_address' => 'dummy',
                    'platform' => 'dummy',
                    'browser' => 'dummy',
                    'mobile' => 'dummy',
                    'referrer' => 'dummy'
                ]);
            }
        } catch (\PDOException $e) {
            return $this->handleDatabaseException($e);
        } catch (\Exception $e) {
            return $this->handleDefaultException($e);
        }

        $this->dispatch('success', 'Dummy berhasil di tambahkan');
        $this->reset();
    }

    public function hydrate()
    {
        $this->resetErrorBag();
        $this->resetValidation();
    }
}
