<?php

namespace App\Livewire;

use App\Livewire\Traits\ExceptionHandler;
use App\Models\WebConfig;
use Livewire\Attributes\Validate;
use Livewire\Component;

class WebSetting extends Component
{
    use ExceptionHandler;
    /**
     * Give context to custom exception handler
     *
     * @var array $context
     */
    protected $context = 'web setting';

    #[Validate('required|string', as: 'Judul web', translate: false)]
    public $title;

    #[Validate('required|string', as: 'Canonical', translate: false)]
    public $canonical;

    #[Validate('required|string', as: 'Keyword', translate: false)]
    public $keyword;

    #[Validate('nullable|string', as: 'Gtag', translate: false)]
    public $gtag;

    #[Validate('required|string', as: 'Deskripsi', translate: false)]
    public $description;

    #[Validate('nullable|string', as: 'Custom CSS', translate: false)]
    public $customCss;

    #[Validate('nullable|string', as: 'Custom JS', translate: false)]
    public $customJs;

    public function messages()
    {
        return [
            'required' => ':attribute tidak boleh kosong',
            'string' => ':attribute tidak boleh memiliki karakter lain selain huruf',
        ];
    }

    public function mount()
    {
        tap(WebConfig::first(), function ($config) {
            $this->title = $config->title;
            $this->canonical = $config->canonical;
            $this->keyword = $config->keyword;
            $this->gtag = $config->gtag;
            $this->description = $config->description;
            $this->customCss = $config->customCss;
            $this->customJs = $config->customJs;
        });
    }

    public function update()
    {
        $request = $this->validate();

        try {
            $config = WebConfig::first();

            $config->title = $request['title'];
            $config->canonical = $request['canonical'];
            $config->keyword = $request['keyword'];
            $config->gtag = $request['gtag'];
            $config->description = $request['description'];
            $config->customCss = $request['customCss'];
            $config->customJs = $request['customJs'];
            $config->save();
        } catch (\PDOException $e) {
            return $this->handleDatabaseException($e);
        } catch (\Exception $e) {
            return $this->handleDefaultException($e);
        }

        $this->dispatch('success', 'Data website berhasil di update');
    }

    public function hydrate()
    {
        $this->resetErrorBag();
        $this->resetValidation();
    }
}
