<?php

namespace App\Providers;

use App\Core\KTBootstrap;
use Illuminate\Support\Facades\Config;
use Illuminate\Database\Schema\Builder;
use Illuminate\Support\Facades\Request;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        Config::set('app.url', Request::getSchemeAndHttpHost());

        // Update defaultStringLength
        Builder::defaultStringLength(191);

        KTBootstrap::init();
    }
}
