<?php

namespace Database\Factories;

use App\Models\Agent;
use App\Models\Bank;
use App\Models\Player;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Transaction>
 */
class TransactionFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'player_id' => function () {
                return Player::all()->random()->id;
            },
            'agent_id' => function () {
                return Agent::all()->random()->id;
            },
            'bank_id' => function () {
                return Bank::all()->random()->id;
            },
            'user_id' => function () {
                return User::all()->random()->id;
            },
        ];
    }
}
