<x-default-layout>
    @section('title')
        Update Logo
    @endsection

    @if ($message = Session::get('success'))
        <div class="alert alert-success d-flex align-items-center p-5">
            {!! getIcon('shield-tick', 'fs-2hx text-success me-4', 'i') !!}
            <div class="d-flex flex-column">
                <h4 class="m-0 text-success">{{ $message }}</h4>
            </div>
        </div>
    @endif

    <div class="card py-6">
        <div class="card-body">
            <form action="/dev/logo-update" id="kt_image_form" class="form" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="row g-5 mb-7">
                    <div class="col fv-row">
                        <label for="logo-lg" class="fw-semibold fs-6 mb-2">Logo Large</label>
                        <input type="file" class="form-control form-control-solid mb-3 mb-lg-0" name="logo_lg"
                            id="logo-lg">
                        @error('logo_lg')
                            <span class="text-danger">{{ $message }}</span>
                        @enderror
                    </div>
                    <div class="col fv-row">
                        <label for="logo-sm" class="fw-semibold fs-6 mb-2">Logo Small</label>
                        <input type="file" class="form-control form-control-solid mb-3 mb-lg-0" name="logo_sm"
                            id="logo-sm">
                        @error('logo_sm')
                            <span class="text-danger">{{ $message }}</span>
                        @enderror
                    </div>
                    <div class="col fv-row">
                        <label for="favicon" class="form-label fw-bold fs-6 mb-2">Favicon</label>
                        <input type="file" class="form-control form-control-solid mb-3 mb-lg-0" name="favicon"
                            id="favicon">
                        @error('favicon')
                            <span class="text-danger">{{ $message }}</span>
                        @enderror
                    </div>
                </div>
                <div class="text-end pt-7">
                    <button type="submit" class="btn btn-primary" id="kt_image_submit">
                        <span class="indicator-label">Simpan</span>
                        <span class="indicator-progress">Loading...
                            <span class="spinner-border spinner-border-sm align-middle ms-2"></span></span>
                    </button>
                </div>
            </form>
        </div>
    </div>
</x-default-layout>
