<x-default-layout>

    @section('title')
        User
    @endsection

    @section('breadcrumbs')
        {{ Breadcrumbs::render('user-management.users.index') }}
    @endsection

    <div class="card">
        <div class="card-header border-0 pt-6">
            <div class="card-title">
                <div class="d-flex align-items-center position-relative my-1">
                    {!! getIcon('magnifier', 'fs-3 position-absolute ms-5') !!}
                    <input type="text" data-kt-user-table-filter="search"
                        class="form-control form-control-solid w-250px ps-13" placeholder="Search user"
                        id="search-input" />
                </div>
            </div>

            <div class="card-toolbar">
                <div class="d-flex justify-content-end" data-kt-user-table-toolbar="base">
                    <button type="button" class="btn btn-primary" data-bs-toggle="modal"
                        data-bs-target="#kt_modal_add_user" data-kt-action="add_user">
                        {!! getIcon('plus', 'fs-2', '', 'i') !!}
                        Tambah User
                    </button>
                </div>
            </div>

            <livewire:user.user-modal />
        </div>

        <div class="card-body py-4">
            <div class="table-responsive">
                {{ $dataTable->table() }}
            </div>
        </div>
    </div>

    @push('scripts')
        {{ $dataTable->scripts() }}
        <script>
            KTUtil.onDOMContentLoaded(function() {
                DTUtilityHandler.init({
                    tableId: 'users-table',
                    useSearch: true,
                });
            });
        </script>
    @endpush
</x-default-layout>
