// Initialize KTMenu
KTMenu.init();

let addButton = document.querySelector('[data-kt-action="add_coupon"]');
let updateButton = document.querySelectorAll('[data-kt-action="update_coupon"]');
let deleteButton = document.querySelectorAll('[data-kt-action="delete_coupon"]');

if (addButton) {
    addButton.addEventListener('click', function () {
        Livewire.dispatch('create');
    });
}

// Add click event listener to update buttons
if (updateButton) {
    updateButton.forEach(function (element) {
        element.addEventListener('click', function () {
            Livewire.dispatch('show', [this.getAttribute('data-kt-coupon-id')]);
        });
    });
}

// Add click event listener to delete buttons
if (deleteButton) {
    deleteButton.forEach(function (element) {
        element.addEventListener('click', function () {
            Swal.fire({
                text: 'Are you sure you want to remove?',
                icon: 'warning',
                buttonsStyling: false,
                showCancelButton: true,
                confirmButtonText: 'Yes',
                cancelButtonText: 'No',
                customClass: {
                    confirmButton: 'btn btn-danger',
                    cancelButton: 'btn btn-secondary',
                }
            }).then((result) => {
                if (result.isConfirmed) {
                    Livewire.dispatch('delete', [this.getAttribute('data-kt-coupon-id')]);
                }
            });
        });
    });
}

Livewire.on('success', (message) => {
    $('#kt_modal_add_coupon').modal('hide');
    LaravelDataTables['coupons-table'].ajax.reload();
});
