<x-default-layout>
    @section('title')
        Dashboard
    @endsection

    @section('breadcrumbs')
        {{ Breadcrumbs::render('dashboard') }}
    @endsection

    <!--begin::Row-->
    <div class="row g-5 g-xl-10 mb-5 mb-xl-10">
        <!--begin::Col-->
        <div class="col-xl-4 mb-md-5 mb-xl-10">
            @include('partials/widgets/cards/_widget-21')
            @include('partials/widgets/cards/_widget-20')
            {{-- @include('partials/widgets/cards/_widget-17') --}}
            {{-- @include('partials/widgets/lists/_widget-26') --}}
        </div>
        <!--end::Col-->
        <!--begin::Col-->
        <div class="col-xl-8">
            @include('partials/widgets/tables/_widget-14')
        </div>
        <!--end::Col-->
    </div>
    <!--end::Row-->
    {{-- <div class="row g-5 g-xl-10 mb-5 mb-xl-10">
        <div class="col">
            @include('partials/widgets/charts/_widget-36')
        </div>
    </div> --}}


    {{-- @push('scripts')
        <script>
            "use strict";

            // Class definition
            var KTChartsWidget36 = function() {
                var chart = {
                    self: null,
                    rendered: false
                };

                // Private methods
                var initChart = function(chart, ) {
                    var element = document.getElementById("kt_charts_widget_36");

                    if (!element) return;

                    var height = parseInt(KTUtil.css(element, 'height'));
                    var labelColor = KTUtil.getCssVariableValue('--bs-gray-500');
                    var borderColor = KTUtil.getCssVariableValue('--bs-border-dashed-color');
                    var baseprimaryColor = KTUtil.getCssVariableValue('--bs-primary');
                    var lightprimaryColor = KTUtil.getCssVariableValue('--bs-primary');
                    var basesuccessColor = KTUtil.getCssVariableValue('--bs-success');
                    var lightsuccessColor = KTUtil.getCssVariableValue('--bs-success');

                    var options = {
                        chart: {
                            fontFamily: 'inherit',
                            type: 'area',
                            height: height,
                            toolbar: {
                                show: false
                            }
                        },
                        plotOptions: {},
                        legend: {
                            show: false
                        },
                        dataLabels: {
                            enabled: false
                        },
                        fill: {
                            type: "gradient",
                            gradient: {
                                shadeIntensity: 1,
                                opacityFrom: 0.4,
                                opacityTo: 0.2,
                                stops: [15, 120, 100]
                            }
                        },
                        stroke: {
                            curve: 'smooth',
                            show: true,
                            width: 3,
                            colors: [baseprimaryColor, basesuccessColor]
                        },
                        states: {
                            normal: {
                                filter: {
                                    type: 'none',
                                    value: 0
                                }
                            },
                            hover: {
                                filter: {
                                    type: 'none',
                                    value: 0
                                }
                            },
                            active: {
                                allowMultipleDataPointsSelection: false,
                                filter: {
                                    type: 'none',
                                    value: 0
                                }
                            }
                        },
                        tooltip: {
                            style: {
                                fontSize: '12px'
                            }
                        },
                        colors: [lightprimaryColor, lightsuccessColor],
                        grid: {
                            borderColor: borderColor,
                            strokeDashArray: 4,
                            yaxis: {
                                lines: {
                                    show: true
                                }
                            }
                        },
                        markers: {
                            strokeColor: [baseprimaryColor, basesuccessColor],
                            strokeWidth: 3
                        }
                    };

                    chart.self = new ApexCharts(element, options);

                    setTimeout(function() {
                        chart.self.render();
                        chart.rendered = true;
                    }, 200);
                }

                // Public methods
                return {
                    init: function(series) {
                        initChart(chart, series);

                        KTThemeMode.on("kt.thememode.change", function() {
                            if (chart.rendered) {
                                chart.self.destroy();
                            }

                            initChart(chart);
                        });
                    }
                }
            }();

            KTUtil.onDOMContentLoaded(function() {
                let series = {{ Js::from($dataSeries) }};
                console.log(series);
                KTChartsWidget36.init(series);
            });
        </script>
    @endpush --}}
</x-default-layout>
