<?php

use Diglactic\Breadcrumbs\Breadcrumbs;
use Diglactic\Breadcrumbs\Generator as BreadcrumbTrail;

// Dashboard
Breadcrumbs::for('dashboard', function (BreadcrumbTrail $trail) {
    $trail->push('Dashboard', null);
});

// Dashboard > Setting
Breadcrumbs::for('setting.index', function (BreadcrumbTrail $trail) {
    $trail->parent('dashboard');
    $trail->push('Setting', null);
});

// Dashboard > Setting > Web
Breadcrumbs::for('setting.web.index', function (BreadcrumbTrail $trail) {
    $trail->parent('setting.index');
    $trail->push('Web', route('setting.web'));
});

// Dashboard > Setting > Wheel
Breadcrumbs::for('setting.wheel.index', function (BreadcrumbTrail $trail) {
    $trail->parent('setting.index');
    $trail->push('Roda Putar', route('setting.wheel'));
});

// Dashboard > Setting > Claim
Breadcrumbs::for('setting.claim.index', function (BreadcrumbTrail $trail) {
    $trail->parent('setting.index');
    $trail->push('Claim', route('setting.claim'));
});

// Dashboard > Roda Putar
Breadcrumbs::for('wheel.index', function (BreadcrumbTrail $trail) {
    $trail->parent('dashboard');
    $trail->push('Roda Putar', null);
});

// Dashboard > Roda Putar > Hadiah
Breadcrumbs::for('wheel.prize.index', function (BreadcrumbTrail $trail) {
    $trail->parent('wheel.index');
    $trail->push('Hadiah', route('wheel.prize'));
});

// Dashboard > Roda Putar > Kupon
Breadcrumbs::for('wheel.coupon.index', function (BreadcrumbTrail $trail) {
    $trail->parent('wheel.index');
    $trail->push('Kupon', route('wheel.coupon'));
});

// Dashboard > Roda Putar > Dummy
Breadcrumbs::for('wheel.dummy.index', function (BreadcrumbTrail $trail) {
    $trail->parent('wheel.index');
    $trail->push('Dummy', route('wheel.dummy'));
});

// Dashboard > User Management
Breadcrumbs::for('user-management.index', function (BreadcrumbTrail $trail) {
    $trail->parent('dashboard');
    $trail->push('User Management', null);
});

// Dashboard > User Management > Users
Breadcrumbs::for('user-management.users.index', function (BreadcrumbTrail $trail) {
    $trail->parent('user-management.index');
    $trail->push('Users', route('user-management.users'));
});

// Dashboard > History
Breadcrumbs::for('history.index', function (BreadcrumbTrail $trail) {
    $trail->parent('dashboard');
    $trail->push('History', null);
});

// Dashboard > History > Spin
Breadcrumbs::for('history.spin.index', function (BreadcrumbTrail $trail) {
    $trail->parent('history.index');
    $trail->push('Spin', route('history.spin'));
});
