<?php

use App\Http\Controllers\Apps\DeveloperFeatureController;
use App\Http\Controllers\Apps\UserManagementController;
use App\Http\Controllers\MasterController;
use App\Http\Controllers\ViewController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', [MasterController::class, 'index'])->name('home');
Route::get('/api/preload', [MasterController::class, 'preload']);
Route::get('/api/validate/{id}', [MasterController::class, 'validate_coupon']);
Route::post('/api/validate/{id}', [MasterController::class, 'save_image']);

Route::middleware('auth')->group(function () {
    Route::name('dev.')->group(function () {
        Route::get('/dev/logo-update', [DeveloperFeatureController::class, 'render_logo_update'])->name('logo-update');
        Route::post('/dev/logo-update', [DeveloperFeatureController::class, 'update_logo']);
    });

    Route::name('setting.')->group(function () {
        Route::get('/setting/web', [ViewController::class, 'render_web_setting'])->name('web');
        Route::get('/setting/wheel', [ViewController::class, 'render_wheel_setting'])->name('wheel');
        Route::get('/setting/claim', [ViewController::class, 'render_claim_setting'])->name('claim');
    });

    Route::name('wheel.')->group(function () {
        Route::get('/wheel/prize', [ViewController::class, 'render_prize'])->name('prize');
        Route::get('/wheel/coupon', [ViewController::class, 'render_coupon'])->name('coupon');
        Route::get('/wheel/dummy', [ViewController::class, 'render_dummy'])->name('dummy');
    });

    Route::name('user-management.')->group(function () {
        Route::get('/user-management/users', [UserManagementController::class, 'index'])->name('users');
    });

    Route::name('history.')->group(function () {
        Route::get('/history/spin', [ViewController::class, 'render_history'])->name('spin');
    });
});

require __DIR__ . '/auth.php';
