<div class="modal fade" id="kt_modal_add_coupon" tabindex="-1" aria-hidden="true" wire:ignore.self>
    <div class="modal-dialog modal-dialog-centered mw-650px">
        <div class="modal-content">
            <div class="modal-header" id="kt_modal_add_coupon_header">
                <h2 class="fw-bold"><?php echo e($title); ?></h2>
                <div class="btn btn-icon btn-sm btn-active-icon-primary" data-bs-dismiss="modal" aria-label="Close">
                    <?php echo getIcon('cross', 'fs-1'); ?>

                </div>
            </div>
            <div class="modal-body px-5 my-7">
                <form id="kt_modal_add_coupon_form" class="form" action="#"
                    wire:submit="<?php echo e($is_edit ? 'update' : 'store'); ?>" enctype="multipart/form-data">
                    <div class="d-flex flex-column scroll-y px-5 px-lg-10" id="kt_modal_add_coupon_scroll"
                        data-kt-scroll="true" data-kt-scroll-activate="true" data-kt-scroll-max-height="auto"
                        data-kt-scroll-dependencies="#kt_modal_add_coupon_header"
                        data-kt-scroll-wrappers="#kt_modal_add_coupon_scroll" data-kt-scroll-offset="300px">
                        <div class="fv-row mb-7">
                            <label class="required fw-semibold fs-6 mb-2">Username</label>
                            <input type="text" wire:model="username" name="username"
                                class="form-control form-control-solid mb-3 mb-lg-0" placeholder="jhondoe" />
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['username'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="text-danger"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>
                        <div class="fv-row mb-7">
                            <label class="fw-semibold fs-6 mb-2">Tanggal Kadaluarsa</label>
                            <input type="date" wire:model="expired"
                                class="form-control form-control-solid mb-3 mb-lg-0"
                                min="<?php echo e(\Carbon\Carbon::now()->format('Y-m-d')); ?>" />
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['expired'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="text-danger"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>
                        <div class="fv-row mb-7">
                            <label class="required fw-semibold fs-6 mb-2">Hadiah</label>
                            <select class="form-select form-select-solid" wire:model="prize" data-control="select2"
                                data-dropdown-parent="#kt_modal_add_coupon" data-dropdown-parent="body">
                                <option value="">Pilih Hadiah</option>
                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $this->prizes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $prize): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($prize->id); ?>"><?php echo e(ucwords($prize->text)); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                            </select>
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['prize'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="text-danger"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>
                    </div>
                    <div class="text-center pt-15">
                        <button type="submit" class="btn btn-primary" data-kt-users-modal-action="submit"
                            wire:loading.attr="disabled" wire:target="__dispatch,update,store">
                            <span class="indicator-label" wire:loading.remove
                                wire:target="__dispatch,update,store">Submit</span>
                            <span wire:loading wire:target="__dispatch,update,store">
                                Please wait...
                                <span class="spinner-border spinner-border-sm align-middle ms-2"></span>
                            </span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php /**PATH C:\laragon\www\luckyspin-lv\resources\views/livewire/coupon-modal.blade.php ENDPATH**/ ?>