<?php

namespace Tests\Feature\Auth;

use App\Models\User;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class AuthenticationTest extends TestCase
{
    use RefreshDatabase;

    /** @test */
    public function login_page_can_be_rendered()
    {
        $response = $this->get('login');

        $response->assertStatus(200);
    }

    /** @test */
    public function users_can_authenticate_using_the_login_page()
    {
        $user = User::factory()->create();

        $response = $this->post('login', [
            'username' => $user->username,
            'password' => 'password',
        ]);

        $this->assertAuthenticated();
        $response->assertRedirect(RouteServiceProvider::HOME);
    }

    /** @test */
    public function users_cannot_authenticate_with_invalid_password()
    {
        $user = User::factory()->create();

        $this->post('login', [
            'username' => $user->username,
            'password' => '123-password',
        ]);

        $this->assertGuest();
    }
}
