<?php

namespace Tests;

use App\Models\User;
use Database\Seeders\RolesPermissionsSeeder;
use Illuminate\Foundation\Testing\TestCase as BaseTestCase;

abstract class TestCase extends BaseTestCase
{
    use CreatesApplication;

    protected $seed = true;

    protected function signIn($user = null, $permission = null)
    {
        $user = $user ?: User::factory()->create();
        if ($permission) {
            $user->givePermissionTo($permission);
        }

        $this->actingAs($user);

        return $user;
    }
}
