<?php

namespace App\Console;

use App\Models\Coupons;
use Carbon\Carbon;
use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;

class Kernel extends ConsoleKernel
{
    const STATUS_NEW = 0;

    const STATUS_USED = 1;

    const STATUS_EXPIRED = 2;

    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        $schedule->call(function () {
            tap(Coupons::all(), function ($coupons) {
                foreach ($coupons as $coupon) {
                    if ($coupon->id === 'ABCDEFGHIJKLMNOP') continue;

                    if (Carbon::today('Asia/Jakarta')->greaterThan($coupon->expired_date) && $coupon->status === 0) {
                        $coupon->delete();
                    }
                }
            });
        })->timezone('Asia/Jakarta')->dailyAt('01:00');

        $schedule->call(function () {
            $count = Coupons::count();
            if ($count > 70) {
                $deletedColumn = $count - 70;

                tap(Coupons::where('status', self::STATUS_USED)->orderBy('created_at')->limit($deletedColumn)->get(), function ($coupons) {
                    $id = $coupons->pluck('id')->toArray();
                    $formatId = implode(', ', array_map(function ($val) {
                        return "'$val'";
                    }, $id));

                    DB::transaction(function () use ($formatId) {
                        DB::statement("DELETE FROM coupons WHERE id IN (" . $formatId . ")");
                        DB::statement("DELETE FROM history WHERE coupon_id IN (" . $formatId . ")");
                    });

                    $paths = array_map(function ($val) {
                        return "assets/screenshot/$val.webp";
                    }, $id);

                    Storage::disk('real_public')->delete($paths);
                });
            }
        })->timezone('Asia/Jakarta')->weekly();
    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__ . '/Commands');

        require base_path('routes/console.php');
    }
}
