<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use Maatwebsite\Excel\Concerns\WithDefaultStyles;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithStrictNullComparison;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Style;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
use Yajra\DataTables\Exports\DataTablesCollectionExport;

class TrasactionExport extends DataTablesCollectionExport implements WithColumnFormatting, WithDefaultStyles, WithStyles, WithStrictNullComparison, WithHeadings, WithMapping
{
    public function columnFormats(): array
    {
        return [
            'E' => '#,##0',
            'F' => '#,##0',
            'G' => '#,##0',
            'H' => '#,##0',
            'I' => '#,##0',
            'J' => '#,##0',
            'K' => '#,##0',
            'L' => '#,##0',
            'M' => '#,##0',
            'N' => '#,##0',
        ];
    }

    public function defaultStyles(Style $defaultStyle)
    {
        return [
            'font' => [
                'name' => 'Calibri',
                'size' => 11,
                'bold' => true,
            ],
            'borders' => [
                'allBorders' => [
                    'borderStyle' => Border::BORDER_THIN,
                    'color' => ['rgb' => '000000']
                ],
            ],
            'alignment' => [
                'horizontal' => Alignment::HORIZONTAL_CENTER,
            ]
        ];
    }

    public function styles(Worksheet $sheet)
    {
        $columnWidth = [
            'A' => 82,
            'B' => 124,
            'C' => 70,
            'D' => 268,
            'E' => 97,
            'F' => 97,
            'G' => 97,
            'H' => 97,
            'I' => 97,
            'J' => 97,
            'K' => 97,
            'L' => 97,
            'M' => 97,
            'N' => 97,
            'O' => 256,
            'P' => 99,
        ];

        foreach ($columnWidth as $column => $width) {
            $sheet->getColumnDimension($column)->setAutoSize(false)->setWidth($width, 'px');
        }

        return [
            'F' => [
                'fill' => [
                    'fillType'   => Fill::FILL_SOLID,
                    'startColor' => ['rgb' => 'a4c2f4'],
                ]
            ],
            'G' => [
                'font' => [
                    'color' => ['rgb' => 'ff0000']
                ]
            ],
            'H' => [
                'fill' => [
                    'fillType'   => Fill::FILL_SOLID,
                    'startColor' => ['rgb' => '00ffff'],
                ],
            ],
            'I' => [
                'fill' => [
                    'fillType'   => Fill::FILL_SOLID,
                    'startColor' => ['rgb' => 'f9cb9c'],
                ]
            ],
            'J' => [
                'fill' => [
                    'fillType'   => Fill::FILL_SOLID,
                    'startColor' => ['rgb' => 'd9d9d9'],
                ]

            ],
            'L' => [
                'font' => [
                    'color' => ['rgb' => 'ff0000']
                ]
            ],
            'N' => [
                'fill' => [
                    'fillType'   => Fill::FILL_SOLID,
                    'startColor' => ['rgb' => 'd9d9d9'],
                ],
                'font' => [
                    'color' => ['rgb' => 'ff0000']
                ]
            ],

            1 => [
                'fill' => [
                    'fillType'   => Fill::FILL_SOLID,
                    'startColor' => ['rgb' => 'a6a6a6'],
                ],
                'font' => [
                    'color' => ['rgb' => '000000']
                ]
            ],
        ];
    }

    public function headings(): array
    {
        return [
            'TGL',
            'USER ID',
            'BANK',
            'NAMA',
            'CR AWAL',
            'DEPOSIT',
            'WD',
            'BONUS',
            'RATE 20%',
            'CR AKHIR',
            'BAL AWAL',
            'TT BAL',
            'BAL AKHIR',
            'TOTAL WD',
            'KETERANGAN',
            'AGENT',
        ];
    }

    public function map($transaction): array
    {
        return [
            $transaction['created_at'],
            $transaction['player_id'],
            $transaction['code'],
            $transaction['name'],
            $transaction['start_credit'],
            $transaction['deposit'],
            $transaction['withdraw'],
            $transaction['bonus'],
            $transaction['rate'],
            $transaction['end_credit'],
            $transaction['start_balance'],
            $transaction['withdraw_balance'],
            $transaction['end_balance'],
            $transaction['total_withdraw'],
            $transaction['keterangan'],
            $transaction['agent_code'],
        ];
    }
}
