<?php

namespace App\Livewire\Traits;

trait ExceptionHandler
{
    public function handleDatabaseException(\PDOException $e, string $context = 'data')
    {
        if (isset($this->context)) {
            $context = $this->context;
        }

        switch ($e->errorInfo[1]) {
            case 1451:
                $this->dispatch('swal', message: "Gagal menghapus $context karena $context terhubung dengan data lainnya.", icon: 'error', confirmButtonText: 'Oke!');
                break;
            case 1062:
                $this->dispatch('swal', message: 'Gagal melakukan aksi, terdeteksi duplikasi data.', icon: 'error', confirmButtonText: 'Oke!');
                break;
            default:
                $this->handleDefaultException($e);
                break;
        }
    }

    public function handleDefaultException(\Exception|\PDOException $e)
    {
        report($e);

        if (app()->environment('local') || auth()->user()->username === 'dev') dd($e);

        $instance = $e instanceof \PDOException ? 'Database' : 'Internal';
        $this->dispatch('swal', message: "Terjadi Kesalahan $instance!", icon: 'error', confirmButtonText: 'Coba Lagi');
    }
}
