<?php

namespace App\Livewire\User;

use App\Livewire\Traits\ExceptionHandler;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Livewire\Attributes\Validate;
use Livewire\Component;

class UpdatePasswordModal extends Component
{
    use ExceptionHandler;

    /**
     * Give context to custom exception handler
     *
     * @var array $context
     */
    protected $context = 'user';

    #[Validate('required', as: 'Password', translate: false)]
    public $password;

    public function messages()
    {
        return [
            'required' => ':attribute tidak boleh kosong',
        ];
    }

    public function update()
    {
        $request = $this->validate();

        try {
            $user = User::find(Auth::id());
            $user->password = Hash::make($request['password']);
            $user->save();
        } catch (\PDOException $e) {
            return $this->handleDatabaseException($e);
        } catch (\Exception $e) {
            return $this->handleDefaultException($e);
        }

        $this->dispatch('success', 'Password berhasil di update');
        $this->reset();
    }

    public function hydrate()
    {
        $this->resetErrorBag();
        $this->resetValidation();
    }
}
