<?php

namespace App\Livewire;

use App\Livewire\Traits\ExceptionHandler;
use App\Models\WebConfig;
use Intervention\Image\Drivers\Imagick\Driver;
use Intervention\Image\ImageManager;
use Livewire\Attributes\Validate;
use Livewire\Component;
use Livewire\WithFileUploads;

class WebImage extends Component
{
    use ExceptionHandler, WithFileUploads;
    /**
     * Give context to custom exception handler
     *
     * @var array $context
     */
    protected $context = 'web setting';

    #[Validate('nullable|mimes:png,jpg,webp', as: 'Icon', onUpdate: false, translate: false)]
    public $icon;

    #[Validate('nullable|mimes:png,jpg,webp', as: 'Open graph image', onUpdate: false, translate: false)]
    public $og_image;

    #[Validate('nullable|mimes:png,jpg,webp', as: 'Twitter image', onUpdate: false, translate: false)]
    public $twt_image;

    public function messages()
    {
        return [
            'required' => ':attribute tidak boleh kosong',
            'string' => ':attribute tidak boleh memiliki karakter lain selain huruf',
            'mimes' => ':attribute hanya menerima ekstensi .png, .jpg, .webp'
        ];
    }

    public function update()
    {
        $request = $this->validate();

        try {
            foreach ($request as $key => $value) {
                if ($value === null) continue;

                $width = $key === 'icon' ? 62 : 800;
                $height = $key === 'icon' ? 62 : 418;

                $formater = new ImageManager(new Driver());
                $image = $formater->read($value);
                $image->resize($width, $height);

                $webp = $image->toWebp();
                $webp->save(public_path('assets/img/' . $key . '.webp'));
            }
        } catch (\PDOException $e) {
            return $this->handleDatabaseException($e);
        } catch (\Exception $e) {
            return $this->handleDefaultException($e);
        }

        $this->dispatch('success', 'Data website berhasil di update');
        $this->reset();
    }

    public function hydrate()
    {
        $this->resetErrorBag();
        $this->resetValidation();
    }
}
