<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Wheel extends Model
{
    use HasFactory;

    protected $table = 'wheel_config';

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'claim_number',
        'claim_text',
        'body_background',
        'popup_background',
        'wheel_background',
        'animation_type',
        'animation_duration',
        'total_spin',
        'win_sound',
        'opening_sound',
        'segment',
        'created_at',
        'updated_at'
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array
     */
    protected $casts = [
        'segment' => 'array',
    ];
}
