<?php

namespace Database\Factories;

use App\Models\Agent;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Player>
 */
class PlayerFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $agentId = Agent::all()->count() ? Agent::all()->random()->id : Agent::factory()->create();

        return [
            'id' => Str::random(8),
            'name' => fake('id_ID')->userName,
            'agent_id' => $agentId
        ];
    }
}
