<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('config', function (Blueprint $table) {
            $table->integerIncrements('id');
            $table->string('title');
            $table->string('canonical');
            $table->string('keyword');
            $table->string('description');
            $table->text('open_graph')->nullable();
            $table->text('twitter')->nullable();
            $table->string('icon');
            $table->string('gtag')->nullable();
            $table->text('customCss')->nullable();
            $table->text('customJs')->nullable();
            $table->integer('maintenance')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('config');
    }
};
