<?php

namespace Database\Seeders;

use App\Models\Coupons;
use App\Models\Prizes;
use App\Models\WebConfig;
use App\Models\Wheel;
use Carbon\Carbon;
use Illuminate\Database\Seeder;

class BaseSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $dataSetting =  [
            'title' => 'Website Title',
            'canonical' => '',
            'keyword' => 'keyword1, keyword2, keyword3',
            'description' => 'Ini merupakan deskripsi website',
            'open_graph' => '',
            'twitter' => '',
            'icon' => 'icon',
            'gtag' => '',
        ];

        $dataPrizes = [
            [
                'id' => '06VA613IU6I9NAJR',
                'text' => 'PRIZE 8',
                'image' => '1679563378.webp',
            ],

            [
                'id' => '7DKFJO6J803TJ0TR',
                'text' => 'PRIZE 7',
                'image' => '1679576577.webp',
            ],

            [
                'id' => '9HWNWWSBHTDXRW88',
                'text' => 'PRIZE 6',
                'image' => '1679576596.webp',
            ],

            [
                'id' => 'OEBRDR9R1TMI7RQW',
                'text' => 'PRIZE 5',
                'image' => '1679576557.webp',
            ],

            [
                'id' => 'PJFAT2JBDROC56ND',
                'text' => 'PRIZE 4',
                'image' => '1679576394.webp',
            ],

            [
                'id' => 'Q6V22PI3NQ3FVVAE',
                'text' => 'PRIZE 3',
                'image' => '1679576527.webp',
            ],

            [
                'id' => 'REORRBWP78K8CT78',
                'text' => 'PRIZE 2',
                'image' => '1679576611.webp',
            ],

            [
                'id' => 'YKJNKMHTHXROEH92',
                'text' => 'PRIZE 1',
                'image' => '1679576620.webp',
            ]
        ];

        $dataWheel = [
            'claim_text' => '',
            'claim_number' => '',
            'body_background' => 'assets/media/wheel/image/background.webp',
            'popup_background' => 'assets/media/wheel/image/popup_logo.webp',
            'wheel_background' => 'assets/media/wheel/image/wheel_background.webp',
            'win_sound' => 'assets/media/wheel/sound/win_sound.mp3',
            'opening_sound' => 'assets/media/wheel/sound/opening_sound.mp3',
            'animation_type' => 'spinToStop',
            'animation_duration' => 5,
            'total_spin' => 2,
            'segment' => [
                ["prize" => "YKJNKMHTHXROEH92", "image" => "assets/img/prizes/1679576620.webp", "text" => "PRIZE 1"],
                ["prize" => "REORRBWP78K8CT78", "image" => "assets/img/prizes/1679576611.webp", "text" => "PRIZE 2"],
                ["prize" => "Q6V22PI3NQ3FVVAE", "image" => "assets/img/prizes/1679576527.webp", "text" => "PRIZE 3"],
                ["prize" => "PJFAT2JBDROC56ND", "image" => "assets/img/prizes/1679576394.webp", "text" => "PRIZE 4"],
                ["prize" => "OEBRDR9R1TMI7RQW", "image" => "assets/img/prizes/1679576557.webp", "text" => "PRIZE 5"],
                ["prize" => "9HWNWWSBHTDXRW88", "image" => "assets/img/prizes/1679576596.webp", "text" => "PRIZE 6"],
                ["prize" => "7DKFJO6J803TJ0TR", "image" => "assets/img/prizes/1679576577.webp", "text" => "PRIZE 7"],
                ["prize" => "06VA613IU6I9NAJR", "image" => "assets/img/prizes/1679563378.webp", "text" => "PRIZE 8"]
            ]
        ];

        $dataCoupon = [
            'id' => 'ABCDEFGHIJKLMNOP',
            'prize_id' => '06VA613IU6I9NAJR',
            'username' => 'tester',
            'status' => 0,
            'expired_date' => Carbon::tomorrow(),
        ];

        WebConfig::create($dataSetting);
        Wheel::create($dataWheel);
        Prizes::insert($dataPrizes);
        Coupons::create($dataCoupon);
    }
}
