"use strict";

// Class definition
let DTUtilityHandler = function () {
    let daterangepicker, table;

    let initDaterange = function () {
        daterangepicker = $('#filter-daterange').daterangepicker({
            "locale": {
                "format": "DD/MM/YYYY",
                "applyLabel": "Apply",
                "cancelLabel": "Cancel",
                "fromLabel": "Dari",
                "toLabel": "Ke",
                "customRangeLabel": "Custom",
                "weekLabel": "W",
                "daysOfWeek": ["Min", "Sen", "Sel", "Rab", "Kam", "Jum", "Sab",],
                "monthNames": ["Januari", "Februari", "Maret", "April", "Mei", "Juni", "Juli", "Agustus",
                    "September", "Oktober", "November", "Desember"
                ]
            }
        });

        handleApllyDaterangePicker();
        handleClearDaterangePicker();
    };

    let handleApllyDaterangePicker = function () {
        daterangepicker.on('apply.daterangepicker', function (ev, picker) {
            let startDate = picker.startDate.format('YYYY-MM-DD');
            let endDate = picker.endDate.format('YYYY-MM-DD');

            if (startDate === endDate) {
                $(this).val('');

                Swal.fire({
                    text: 'Harus memilih jangka waktu minimal 1 hari',
                    icon: 'error',
                    buttonsStyling: false,
                    confirmButtonText: 'Oke',
                    customClass: {
                        confirmButton: 'btn btn-primary'
                    }
                });

                return;
            }

            LaravelDataTables[table].column(0).search(startDate + '|' + endDate).draw();
        });
    };

    let handleClearDaterangePicker = function () {
        $('#clear-daterange').on('click', function (e) {
            daterangepicker.val('');
            LaravelDataTables[table].column(0).search('').draw();
        });
    };

    let handleSearchDatatable = function () {
        $('#search-input').on('keyup', function () {
            LaravelDataTables[table].search(this.value).draw();
        });
    };

    let handleFilterDatatable = function (filterCol = '') {
        $('#filter-input').on('change', function (e) {
            let searchCol = typeof filterCol === 'function' ? filterCol(this) : filterCol;
            let searchVal = this.value !== 'all' ? this.value : '';
            LaravelDataTables[table].columns().search('').column(searchCol).search(searchVal).draw();
        });
    };

    return {
        init: function (
            { tableId, useSearch = false, useFilter = false, useDaterangePicker = false, filterCol = '' }) {
            table = tableId;
            if (useSearch) handleSearchDatatable();
            if (useFilter) handleFilterDatatable(filterCol);
            if (useDaterangePicker) initDaterange();
        }
    };
}();
