<!DOCTYPE html>
<html lang="id">

<head>
    @if ($settings->gtag)
        <script async="" src="https://www.googletagmanager.com/gtag/js?id={!! $settings->gtag !!}"></script>
        <script>
            window.dataLayer = window.dataLayer || [];

            function gtag() {
                dataLayer.push(arguments);
            }
            gtag('js', new Date());

            gtag('config', {!! $settings->gtag !!});
        </script>
    @endif

    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $settings->title }}</title>

    <meta name="keywords" content="<?= $settings->keyword ?>">
    <meta name="description" content="<?= $settings->description ?>">
    <meta name="rating" content="general">

    <meta name="robots" content="index, follow">

    @if ($settings->open_graph)
        <meta property="og:image"
            content="<?= asset('assets/img/' . $settings->open_graph['image'] . '?v=' . $settings->updated_at->timestamp) ?>">
        <meta property="og:site_name" content="<?= $settings->open_graph['site_name'] ?>">
        <meta property="og:title" content="<?= $settings->open_graph['title'] ?>">
        <meta property="og:description" content="<?= $settings->open_graph['description'] ?>">
        <meta property="og:type" content="<?= $settings->open_graph['type'] ?>">
        <meta property="og:url" content="<?= $settings->open_graph['url'] ?>">
        <meta property="og:locale" content="id_ID">
    @endif

    @if ($settings->twitter)
        <meta name="twitter:card" content="<?= $setting->twitter['card'] ?>">
        <meta name="twitter:site" content="<?= $setting->twitter['site'] ?>">
        <meta name="twitter:creator" content="<?= $setting->twitter['creator'] ?>">
        <meta name="twitter:url" content="<?= $setting->twitter['url'] ?>">
        <meta name="twitter:title" content="<?= $setting->twitter['title'] ?>">
        <meta name="twitter:description" content="<?= $setting->twitter['description'] ?>">
        <meta name="twitter:image"
            content="<?= asset('assets/img/' . $setting->twitter['image'] . '?v=' . $settings->updated_at->timestamp) ?>">
    @endif

    <!-- Favicon Meta Tags.  -->
    <link rel="icon" href="assets/media/logo/icon.webp" sizes="62x62" type="image/webp">

    <!-- Apple iOS Settings. -->
    <link rel="apple-touch-icon" sizes="62x62" href="assets/media/logo/icon.webp">
    <!-- Google Chrome. -->
    <meta name="google" value="notranslate">
    <link rel="canonical" href="{{ $settings->canonical }}" />

    <!-- External Stylesheets. -->
    <link rel="preload" href="{{ asset('assets/fonts/static/Inter-Bold.ttf') }}" as="font"
        crossorigin="anonymous" />
    <link rel="preload" href="{{ asset('assets/fonts/static/Inter-Regular.ttf') }}" as="font"
        crossorigin="anonymous" />
    <link rel="preload" href="{{ asset('assets/fonts/static/Inter-SemiBold.ttf') }}" as="font"
        crossorigin="anonymous" />
    <link rel="preload" href="{{ asset('assets/img/body_background.webp?v=' . $timestamp) }}" as="image" />
    <link rel="preload" href="{{ asset('assets/img/popup.webp?v=' . $timestamp) }}" as="image" />
    <link rel="preload" href="{{ asset('assets/img/wheel_background.webp?v=' . $timestamp) }}" as="image" />

    <link rel="stylesheet" href="{{ asset('assets/main/styles.bundle.css') }}">
    <script defer src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.11.5/gsap.min.js"></script>

    @if ($settings->customCss)
        <style>
            {!! $settings->customCss !!}
        </style>
    @endif
</head>

<body>
    <main class="container">
        <section class="logo-image-lg">
            <img src="{{ asset('assets/img/popup.webp?v=' . $timestamp) }}" alt="website logo">
        </section>
        <section class="wheel-container">
            <canvas id="wof" data-scaleheight="true" height="630" width="630"></canvas>
        </section>
        <section class="form-container">
            <img class="logo-image-sm" src="{{ asset('assets/img/popup.webp?v=' . $timestamp) }}" alt="website logo">
            <div class="form-group">
                <label for="coupon-input" class="coupon-code">MASUKAN KUPON</label>
                <input type="text" id="coupon-input" placeholder="TE00937HIPOPARC8">
            </div>
            <button class="btn btn-spin">SPIN</button>
            <button class="btn btn-history">HISTORY</button>
        </section>
    </main>

    <div class="overlay"></div>
    <section class="modal js-popup">
        <div class="popup-modal"></div>
    </section>
    <section class="modal hidden js-win">
        <div class="win-modal">
            <h1>Selamat Anda Memenangkan</h1>
            <div class="content">
                <div class="prize-info">
                    <p id="prize_text"></p>
                    <img id="prize_image" src="" alt="prize image">
                </div>
                <div class="winner-info">
                    <p>USERNAME: <span id="username"></span></p>
                    <p>KUPON: <span id="coupon"></span></p>
                </div>
                <button class="btn btn-claim">Klaim Hadiah</button>
            </div>
        </div>
    </section>
    <section class="modal hidden js-history">
        <div class="history-modal">
            <table>
                <thead>
                    <tr>
                        <td>Username</td>
                        <td>Hadiah</td>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($history as $item)
                        <tr>
                            <td>{{ $item->username }}</td>
                            <td>{{ $item->text }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </section>
</body>

<script defer src="{{ asset('assets/main/vendor.bundle.js') }}"></script>
<script src="{{ asset('assets/main/scripts.bundle.js') }}"></script>
@if ($settings->customJs)
    <script>
        {!! $settings->customJs !!}
    </script>
@endif
<script>
    document.addEventListener("DOMContentLoaded", () => {
        let overlay = document.querySelector('.overlay');
        let historyButton = document.querySelector('.btn.btn-history');
        let termsAndCondition = historyButton.cloneNode(true);
        termsAndCondition.id = 'terms';
        termsAndCondition.className = 'btn btn-terms';
        termsAndCondition.textContent = 'ATURAN MAIN';
        historyButton.after(termsAndCondition);

        let termsModalContainer = document.querySelector('.modal.js-popup');
        let closeModalBtn = document.querySelector('.close-modal-btn');

        termsAndCondition.addEventListener('click', () => {
            showModals(termsModalContainer);
        });

        overlay.addEventListener('click', e => {
            closeModal(termsModalContainer)
        });

        closeModalBtn.addEventListener('click', () => {
            closeModal(termsModalContainer);
        });

        function showModals(element) {
            overlay.classList.remove('hidden');
            element.classList.remove('hidden');
        }

        function closeModal(element) {
            overlay.classList.add('hidden');
            element.classList.add('hidden');
        }
    });
</script>

</html>
