<div class="modal fade" id="kt_modal_update_prize" tabindex="-1" aria-hidden="true" wire:ignore.self>
    <div class="modal-dialog modal-dialog-centered mw-650px">
        <div class="modal-content">
            <div class="modal-header" id="kt_modal_update_prize_header">
                <h2 class="fw-bold">Update Hadiah</h2>
                <div class="btn btn-icon btn-sm btn-active-icon-primary" data-bs-dismiss="modal" aria-label="Close">
                    {!! getIcon('cross', 'fs-1') !!}
                </div>
            </div>
            <div class="modal-body px-5 my-7">
                <form id="kt_modal_update_prize_form" class="form" action="#" wire:submit="update"
                    enctype="multipart/form-data">
                    <div class="d-flex flex-column scroll-y px-5 px-lg-10" id="kt_modal_update_prize_scroll"
                        data-kt-scroll="true" data-kt-scroll-activate="true" data-kt-scroll-max-height="auto"
                        data-kt-scroll-dependencies="#kt_modal_update_prize_header"
                        data-kt-scroll-wrappers="#kt_modal_update_prize_scroll" data-kt-scroll-offset="300px">
                        <div class="fv-row mb-7">
                            <label class="required fw-semibold fs-6 mb-2">Hadiah</label>
                            <input type="text" wire:model="text" class="form-control form-control-solid mb-3 mb-lg-0"
                                placeholder="Iphone 14 Pro" />
                            @error('text')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                        <div class="fv-row">
                            <label for="image" class="form-label fw-bold fs-6 mb-2">Gambar Hadiah</label>
                            <input type="file" class="form-control form-control-solid mb-3 mb-lg-0"
                                wire:model="image" id="image">
                            @error('image')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="text-center pt-15">
                        <button type="submit" class="btn btn-primary" data-kt-users-modal-action="submit"
                            wire:loading.attr="disabled" wire:target="__dispatch,image,update">
                            <span class="indicator-label" wire:loading.remove
                                wire:target="__dispatch,image,update">Submit</span>
                            <span wire:loading wire:target="__dispatch,image,update">
                                Please wait...
                                <span class="spinner-border spinner-border-sm align-middle ms-2"></span>
                            </span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
