<x-default-layout>

    @section('title')
        Riwayat Spin
    @endsection

    @section('breadcrumbs')
        {{ Breadcrumbs::render('history.spin.index') }}
    @endsection

    <div class="card">
        <div class="card-header border-0 pt-6">
            <div class="card-title">
                <div class="d-flex align-items-center position-relative my-1">
                    {!! getIcon('magnifier', 'fs-3 position-absolute ms-5') !!}
                    <input type="text" data-kt-logs-table-filter="search"
                        class="form-control form-control-solid w-250px ps-13" placeholder="Search kupon"
                        id="search-input" />
                </div>
            </div>
            <div class="card-toolbar flex-row-fluid justify-content-end gap-5"></div>
        </div>

        <div class="card-body py-4">
            <div class="table-responsive">
                {{ $dataTable->table() }}
            </div>
        </div>
    </div>

    @push('scripts')
        {{ $dataTable->scripts() }}
        <script>
            KTUtil.onDOMContentLoaded(function() {
                DTUtilityHandler.init({
                    tableId: 'logs-table',
                    useSearch: true,
                });
            });
        </script>
    @endpush
</x-default-layout>
